---
title: Activate the Cloudflare WordPress plugin · Cloudflare Automatic Platform
  Optimization docs
description: The easiest way to begin using APO is directly from Cloudflare’s
  WordPress plugin. Before you can use APO, you must first install and activate
  the plugin and then activate APO.
lastUpdated: 2025-10-22T09:10:43.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/automatic-platform-optimization/get-started/activate-cf-wp-plugin/
  md: https://developers.cloudflare.com/automatic-platform-optimization/get-started/activate-cf-wp-plugin/index.md
---

After you [change your nameservers](https://developers.cloudflare.com/automatic-platform-optimization/get-started/change-nameservers/), activate the Cloudflare WordPress plugin.

## Prerequisites

Before activating the Cloudflare WordPress plugin, review the following prerequisites.

### Plan type

For users on the free plan, [purchase APO](#purchase-apo) before installing the WordPress plugin.

For users on a Pro plan or higher, continue to [Install and activate](#install-and-activate-the-cloudflare-wordpress-plugin) the Cloudflare WordPress plugin.

### Plugin compatibility

Cloudflare recommends turning off plugins such as WP Rocket Cache Plugin, W3 Total Cache, or similar plugins when first setting up APO. After confirming APO is working, we recommend testing whether turning on the plugins listed above improves results or causes unexpected behavior. In many cases, using APO along with other caching plugins can cause unexpected results.

We also recommend clearing the server cache for the WP Rocket Cache plugin, W3 Total Cache, or similar plugins after APO activation.

For more details, refer to [Plugin compatibility](https://developers.cloudflare.com/automatic-platform-optimization/about/plugin-compatibility/).

### Limitations

The Cloudflare APO WordPress plugin does not support multisite WordPress installation.

## Purchase APO

1. In the Cloudflare dashboard, go to the **Speed** > **Settings** page.

   [Go to **Settings**](https://dash.cloudflare.com/?to=/:account/:zone/speed/optimization)

2. Go to **Content Optimization**.

3. For **Automatic Platform Optimization for WordPress**, select **Purchase**.

4. Enter your payment information and select **Confirm payment**.

## Install and activate the Cloudflare WordPress plugin

The easiest way to begin using APO is directly from Cloudflare’s WordPress plugin. Before you can use APO, you must first install and activate the plugin and then activate APO.

1. Navigate and log in to your WordPress account.
2. Select **Plugins** > **Add new**.
3. In the search field, enter `Cloudflare`.
4. Locate the Cloudflare plugin and select **Install now**.
5. After the plugin finishes installing, select **Activate**. The Cloudflare plugin now displays in your Plugins list.

## Activate APO

To create the connection between WordPress and Cloudflare, you will create an API token from your Cloudflare dashboard and add it to WordPress. To set up APO on a subdomain, refer to [Subdomains and subdirectories](https://developers.cloudflare.com/automatic-platform-optimization/reference/subdomain-subdirectories/).

## Create the API token from Cloudflare

1. In the Cloudflare dashboard, go to the **Account API tokens** page.

   [Go to **Account API tokens**](https://dash.cloudflare.com/?to=/:account/api-tokens)

2. Select **Create Token**.

3. Locate **WordPress** from the list and select **Use template**.

4. Select **Continue to summary** at the bottom of the page.

5. On the **WordPress API token summary** page, select **Create Token**. Your API token displays.

6. Select the **Copy** button to copy your token. You will need to paste the token in the next section.

Note

Copy and paste your API token into a document saved on your computer to easily reference it again.

## Add your API token to WordPress

1. Open your WordPress account and navigate to Plugins.
2. Locate the Cloudflare plugin and select **Settings**.
3. Select the option to sign in with an existing account.
4. Enter your email address and paste the token you copied in Step 7 of Create the API token from Cloudflare.
5. Select **Save API Credentials**.
6. For **Apply Recommended Cloudflare Settings for WordPress**, select **Apply**.
7. For **Automatic Platform Optimization**, switch the toggle to **On** to enable APO.

To verify APO is working, see [Verify APO works](https://developers.cloudflare.com/automatic-platform-optimization/get-started/verify-apo-works/).
