---
title: Troubleshooting client certificates · Cloudflare SSL/TLS docs
description: Troubleshoot issues with client certificates
lastUpdated: 2025-10-28T14:13:10.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/ssl/client-certificates/troubleshooting/
  md: https://developers.cloudflare.com/ssl/client-certificates/troubleshooting/index.md
---

If your query returns an error even after configuring and embedding a client SSL certificate, check the following settings.

***

## Check SSL/TLS handshake

On your terminal, use the following command to check whether an SSL/TLS connection can be established successfully between the client and the API endpoint.

```sh
curl --verbose --cert /path/to/certificate.pem --key /path/to/key.pem  https://your-api-endpoint.com
```

If the SSL/TLS handshake cannot be completed, check whether the certificate and the private key are correct.

***

## Check mTLS hosts

Check whether [mTLS has been enabled](https://developers.cloudflare.com/ssl/client-certificates/enable-mtls/) for the correct host. The host should match the API endpoint that you want to protect.

***

## Review mTLS rules

To review mTLS rules, consider the steps below. For further guidance refer to [Custom rules](https://developers.cloudflare.com/waf/custom-rules/create-dashboard/).

1. In the Cloudflare dashboard, go to the **Security rules** page.

   [Go to **Security rules**](https://dash.cloudflare.com/?to=/:account/:zone/security/security-rules)

2. On a specific rule, select **Edit**.

3. On that rule, check whether:

   * The Expression Preview is correct.

   * The hostname, if defined, matches your API endpoint. For example, for the API endpoint `api.trackers.ninja/time`, the rule should look like:

     ```txt
     (http.host in {"api.trackers.ninja"} and not cf.tls_client_auth.cert_verified)
     ```

4. To edit the rule, either use the user interface or select **Edit expression**.
